%locations

%{
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "parser.h"
#include "lexer.h"
#include "lines.h"
#include "minibas.h"

char* label;
char* ident;
char* string;
short val;
int i;
char ch;
int res;
frefsym* frs;
frefline* frl;

int exprError; 

extern line *cline;

extern int yycolumn;
extern int yylineno;

extern int yylex();
%}

%output "parser.c"
%defines "parser.h"

%union {
	int         num;
	char       *ident;
}

%type <num>		Expr

%token <num> T_NUM
%token <ident> T_IDENT
%token <ident> T_LABEL
%token <ident> T_STRING
%token T_PLUS T_MINUS T_TIMES T_DIVIDE
%token T_LPAR T_RPAR
%token T_COMMA
%token T_DOT
%token T_AT
%token T_EOL
%token T_COMM

%left T_PLUS T_MINUS
%left T_TIMES T_DIVIDE
%left NEG

%token <ident> T_BYTE
%token <ident> T_WORD
%token <ident> T_ORG
%token <ident> T_ASCIZ
%token <ident> T_ASCII
%token <ident> T_SPACE
%token <ident> T_EQU
%token <ident> T_ALIGN

%token <num>   T_INSTR

%start Program
%%

Program:    
    | Program Line
;

Line:
    T_COMM {
      cline->token = T_COMM;                            /* comment line */
      cline->lc = lc;
    }
    |
    T_EOL {                                 
      cline->token = T_EOL;                             /* empty line */
      cline->lc = lc;
    }
    | T_LABEL T_EOL  {                                  /* label: */
      cline->token = T_LABEL;
      cline->label = copy_str($1);
      cline->lbval = lc;
      cline->lc = lc;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_LABEL T_DOT T_EOL  {                            /* label:  . */
      cline->token = T_DOT;
      cline->label = copy_str($1);
      cline->lbval = lc;
      cline->lc = lc;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_ALIGN T_NUM T_EOL {
      cline->token = T_ALIGN;
      cline->lc = lc;
      if ($2 == 1) {
        nargs = 0;
        if (lc & 0x0001) {
          nargs = 1;
          first_arg = mk_arg(0xC0);                     /* 0xC0 IF instruction */
          cline->args = first_arg;
          last_arg = first_arg;

          lc += 1;
        }                                              
      } else {
          yyerror("only .align 1 is implememented");
      }
    }
    | T_ORG Expr T_EOL {                                /* .org expression */
      if (!exprError) {
        cline->token = T_ORG;
        cline->lc = lc;
        lc = $2;
      } else {
        yycolumn = yylloc.first_column;
        yyerror("Forward reference");
      }
    }
    | T_LABEL T_ORG Expr T_EOL {                        /* label: .org expression */
      cline->token = T_ORG;
      label = copy_str($1);
      cline->label = label;
      cline->lbval = lc;
      cline->lc = lc;
      lc = $3;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_EQU T_IDENT T_COMMA Expr T_EOL {                /* .equ symbol, expression */
      if (cline->reeval) {
        ident = copy_str($2);
        cline->ident = ident;
      } else {
        if (cline->idtype != EVAL) {
          cline->token = T_EQU;
          ident = copy_str($2);
          cline->ident = ident;
        }
        cline->idval = $4;
      }      
      if (frslookup(cline->ident, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_SPACE Expr T_EOL {                             /* .space size */
      cline->token = T_SPACE;
      cline->lc = lc;
      lc += $2;
      fill($2, 0);
    }
    | T_LABEL T_SPACE Expr T_EOL {                     /* label: .space size */
      cline->label = copy_str($1); 
      cline->token = T_SPACE;
      cline->lbval = lc; 
      cline->lc = lc;
      lc += $3;
      fill($3, 0);

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_SPACE T_NUM T_COMMA T_NUM T_EOL {               /* .space size, fill */
      cline->token = T_SPACE;
      cline->lc = lc;
      lc += $2;
      fill($2, $4);
    }
    | T_LABEL T_SPACE T_NUM T_COMMA T_NUM T_EOL {       /* label: .space size, fill */
      cline->label = copy_str($1); 
      cline->token = T_SPACE;
      cline->lbval = lc; 
      cline->lc = lc;
      lc += $3;
      fill($3, $5);

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_BYTE Expr_list T_EOL {                          /* .byte expressions */
      if (!cline->reeval) {
        cline->token = T_BYTE;
        cline->lc = lc;
        lc += nargs;
      }
    }
    | T_LABEL T_BYTE Expr_list T_EOL {                  /* label: .byte expressions */            
      if (!cline->reeval) {
        cline->token = T_BYTE;
        label = copy_str($1);
        cline->label = label;
        cline->lbval = lc;
        cline->lc = lc;
        lc += nargs;
      }

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_WORD Expr_list T_EOL {                          /* .word expressions */
      if (!cline->reeval) {
        cline->token = T_WORD;
        cline->lc = lc;
        lc += 2*nargs;
      }
    }
    | T_LABEL T_WORD Expr_list T_EOL {                  /* label: .word expressions */
      if (!cline->reeval) {
        cline->token = T_WORD;
        cline->label = copy_str($1);
        cline->lbval = lc;
        cline->lc = lc;
        lc += 2*nargs;

        if (frslookup(cline->label, &frs) == 1) {
            frl = frs->head;
            reeval = true;
        }
      }
    }
    | T_ASCIZ T_STRING T_EOL {                          /* .asciz "string ". . .*/
      cline->token = T_ASCIZ;
      cline->lc = lc;
      string = $2;
      i = 0;
      ch = '\000';
      nargs = 0;
      first_arg = mk_arg(string[i++]);
      cline->args = first_arg;
      last_arg = first_arg;
      while (ch = string[i++]) {
        last_arg->next = mk_arg(ch);
        last_arg = last_arg->next;
      }
      ch = '\000';
      last_arg->next = mk_arg(ch);
      lc += 2*nargs;
    }
    | T_LABEL T_ASCIZ T_STRING T_EOL {                  /* label: .asciz "string ". . .*/
      label = copy_str($1);
      cline->label = label;
      cline->lbval = lc;
      cline->token = T_ASCIZ;
      cline->lc = lc;
      string = $3;
      i = 0;
      ch = '\000';
      nargs = 0;
      first_arg = mk_arg(string[i++]);
      cline->args = first_arg;
      last_arg = first_arg;
      while (ch = string[i++]) {
        last_arg->next = mk_arg(ch);
        last_arg = last_arg->next;
      }
      ch = '\000';
      last_arg->next = mk_arg(ch);
      lc += 2*nargs;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }
    | T_ASCII T_STRING T_EOL {                          /* .ascii "string ". . .*/
      cline->token = T_ASCII;
      cline->lc = lc;
      string = $2;
      i = 0;
      ch = '\000';
      nargs = 0;
      first_arg = mk_arg(string[i++]);
      cline->args = first_arg;
      last_arg = first_arg;
      while (ch = string[i++]) {
        last_arg->next = mk_arg(ch);
        last_arg = last_arg->next;
      }
      lc += 2*nargs;
    }
    | T_LABEL T_ASCII T_STRING T_EOL {                  /* label: .ascii "string ". . .*/
      label = copy_str($1);
      cline->label = label;
      cline->lbval = lc;
      cline->token = T_ASCII;
      cline->lc = lc;
      string = $3;
      i = 0;
      ch = '\000';
      nargs = 0;
      first_arg = mk_arg(string[i++]);
      cline->args = first_arg;
      last_arg = first_arg;
      while (ch = string[i++]) {
        last_arg->next = mk_arg(ch);
        last_arg = last_arg->next;
      }
      lc += 2*nargs;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    }

    | T_INSTR T_EOL {                                   /* instr */
      cline->token = T_INSTR;
      cline->idval = $1 << 16;
      cline->lc = lc;
      lc += 1;
    } 
    | T_LABEL T_INSTR T_EOL {                           /* label: instr */
      label = copy_str($1);
      cline->label = label;
      cline->lbval = lc;
      cline->token = T_INSTR;
      cline->idval = $2 << 16;
      cline->lc = lc;
      lc += 1;

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    } 
    | T_INSTR Expr T_EOL  {                             /* instr expr */
      if (cline->reeval) {
        val = $2 & 0xFFFF;
        cline->idval = (($1 | 0x02) << 16) | val;
      } else {
        cline->token = T_INSTR;
        val = $2 & 0xFFFF;
        cline->lc = lc;
        if (($1 & 0xFF) >= 0xD0) {
          cline->idval = ($1 << 16) | val;
          lc += 1;
          if ($2 > 15)
            yyerror("número de periférico inválido");
        } else {
          cline->idval = (($1 | 0x02) << 16) | val;
          lc += 2;
        }
      }
    } 
    | T_LABEL T_INSTR Expr T_EOL  {                     /* label: instr expr */
      if (cline->reeval) {
        val = $3 & 0xFFFF;
        cline->idval = (($2 | 0x02) << 16) | val;
      } else {
        label = copy_str($1);
        cline->label = label;
        cline->lbval = lc;
        cline->token = T_INSTR;
        val = $3 & 0xFFFF;
        cline->idval = (($2 | 0x02) << 16) | val;
        cline->lc = lc;
        if (($2 & 0xFF) >= 0xD0) {
          lc += 1;
          if ($3 > 15)
            yyerror("número de periférico inválido");
        } else {
          lc += 2;
        }

        if (frslookup(cline->label, &frs) == 1) {
          frl = frs->head;
          reeval = true;
        }
      }
    } 

    | T_INSTR T_AT Expr T_EOL  {                         /* instr @expr */
      if (cline->reeval) {
        val = $3 & 0xFFFF;
        cline->idval = ($1 << 16) | val;
      } else {
        cline->token = T_INSTR;
        val = $3 & 0xFFFF;
        cline->idval = ($1 << 16) | val;
        cline->lc = lc;
        if (($1 & 0xFF) >= 0xD0) {
          lc += 1;
          if ($3 > 15)
            yyerror("número de periférico inválido");
        } else {
          lc += 2;
        }
      }
    } 
    | T_LABEL T_INSTR T_AT Expr T_EOL  {                /* label: instr @expr */
      if (cline->reeval) {
        val = $4 & 0xFFFF;
        cline->idval = ($2 << 16) | val;
      } else {
        label = copy_str($1);
        cline->label = label;
        cline->lbval = lc;
        cline->token = T_INSTR;
        val = $4 & 0xFFFF;
        cline->idval = ($2 << 16) | val;
        cline->lc = lc;
        if (($2 & 0xFF) >= 0xD0) {
          lc += 1;
          if ($4 > 15)
            yyerror("número de periférico inválido");
        } else {
          lc += 2;
        }
      }

      if (frslookup(cline->label, &frs) == 1) {
        frl = frs->head;
        reeval = true;
      }
    } 

;

Expr_list:
     Expr_loop                                                         
;

Expr_loop:
     Expr {
       nargs = 0;
       first_arg = mk_arg($1);
       cline->args = first_arg;
       last_arg = first_arg;
     }                     
     | Expr_loop T_COMMA Expr {
       last_arg->next = mk_arg($3);
       last_arg = last_arg->next;
     }
;

Expr:
    T_NUM {
        $$=$1;
        cline->idtype = DEF;
        exprError = 0;
    }
    | T_DOT {
        $$=lc;
        cline->idtype = DEF;
        exprError = 0;
    }
    | T_IDENT {
      ident = copy_str($1);
      if (lblookup(ident, &val) == 1 || idlookup(ident, &val) == 1) {
        $$ = val;
        cline->idtype = DEF;
        exprError = 0;
      } else {
        $$ = 0;
        if (cline->idtype != EVAL) {
          cline->frefno++;
          if (frslookup(ident, &frs) == 1) {
            frl = mk_frefline(cline);
            frs->tail->next = frl;
            frs->tail = frl;
          } else {
            frs = mk_frefsym(ident, cline);
          }
        }
        cline->idtype = UDEF;
        exprError = 1;
      }
      if (cline->idtype == DEF && cline->token == T_INSTR) {
        int lcpag = cline->lc >> 8;
        int idpag = $$ >>8;
        if (idpag >= 3 && idpag != lcpag) {
          error = 1;
          printf("%s:%d:%d:%s\n", filename, cline->lineno, 0, "Referencia a una página que no es la presente");
        }
      }
    }
    | Expr T_PLUS Expr                      { $$=$1+$3; }
    | Expr T_MINUS Expr                     { $$=$1-$3; }
    | Expr T_TIMES Expr                     { $$=$1*$3; }
    | Expr T_DIVIDE Expr                    { $$=$1/$3; }
    | T_MINUS Expr %prec NEG                { $$=-$2; }
    | T_LPAR Expr T_RPAR                    { $$=$2; }
;

%%

int yyerror(char *s) {
    error = 1;
    printf("%s:%d:%d:%s\n", filename, yylineno, yycolumn, s);
}

