#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "lines.h"
#include "minibas.h"

FILE *obj;                                                       /* object file */
char objname[NAMELEN];                                           /* object file's name */
FILE *lst;                                                       /* listing file */
char lstname[NAMELEN];                                           /* listing file's name */
FILE *in;                                                               
char filename[NAMELEN];

bool reeval;
int lc;
int error;
line *cline;

extern int yylineno;

int main(int argc, char *argv[]) {
    size_t pos, length;
    int j;
    int dot;                                                        /* location of last dot in filename */

	init_lines();

    reeval= false;
    hexeor = false;

    yycolumn = 1;
    yylineno = 1;
    lc = 0;

    if (argc == 1) {
        strcpy(filename, "sample.s");
    }
    else if(argc == 2) {
        strcpy(filename, argv[1]);
    }
    else {
        printf("minias [file].\n");
    }

	/* now, fix up the file names */
	{
		dot = 0;
		for (j = 0; filename[j] != 0; j++) {
			if (j > (NAMELEN - 5)) {
				fprintf( stderr, "%s: file name too long %s\n", argv[0], filename );
				exit(-1);
			}
			lstname[j] = objname[j] = filename[j];
			if (filename[j]=='.') {
				dot = j;
			} else if (filename[j]=='/') {
				dot = 0;
			}
		}
		if (dot == 0) {
			dot = j;
			lstname[dot] = objname[dot] = '.';
		}
		lstname[dot + 1] = 'l';
		lstname[dot + 2] = 's';
		lstname[dot + 3] = 't';
		lstname[dot + 4] = '\0';

		objname[dot + 1] = 'h';
		objname[dot + 2] = 'e';
		objname[dot + 3] = 'x';
		
		objname[dot + 4] = '\0';
    }


	if ((in = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "%s: cannot open %s\n", argv[0], filename);
		exit(-1);
	}
    
    obj = fopen(objname, "w");
    lst = fopen(lstname, "w");

    yyparse();
    if (!error) {
        print_lines(head);
        print_symbols(head);
    }
#if 0
    printf("===> %s", cline->srcline);
    printf("===> print_frefsyms <===\n");
    print_frefsyms(frshead);
#endif


    fclose(in);
    fclose(obj);

    return 0;
}

int readInputForLexer(char *buffer, int *numBytesRead, int maxBytesToRead) {
    int numBytesToRead;
    char * srcline;

    if (reeval) {
        cline = frl->line;
        strcpy(buffer, cline->srcline);
        numBytesToRead = (int)strlen(cline->srcline);
        cline->reeval = true;
        frl = frl->next;
        if (frl == NULL)
            reeval = false;
    } else {
        if (fgets(buffer, LINELEN, in) != NULL) {
            srcline = copy_str(buffer);
            mk_line(yylineno, srcline);
            cline = tail;
            yylineno++;
            numBytesToRead = (int)strlen(buffer);
        } else
            numBytesToRead = 0;
    }
        
    *numBytesRead = numBytesToRead;

    return 0;
}
