#ifndef LINES_FILE_H
#define LINES_FILE_H

#include <stdbool.h>

#define uint16(v) *(unsigned short *)&v
#define uint8(v) *(unsigned char *)&v

extern bool hexeor;

enum type {UDEF, DEF, EVAL};

extern int nargs;
typedef struct arg {
	short  val;
	struct arg *next;
} arg;

extern arg *first_arg;
extern arg *last_arg;

typedef struct rsym {
    char            *name;

	struct rsym     *prev;
	struct rsym     *next;
} rsym;

typedef struct line {
    int             lineno;
    short           lc;
    char            *label;
    short           lbval;
    int             token;
    char            *ident;
    int             idval;
    int             idtype;

    int             frefno;

    arg             *args;

    bool            reeval;
	char            *srcline;

	struct line     *prev;
	struct line     *next;
} line;

extern line *tail;
extern line *head;

typedef struct frefline {
	line *line;

	struct frefline *next;
} frefline;

extern frefline *frl;

typedef struct frefsym {
	char * sym;
    frefline *head;
    frefline *tail;

	struct frefsym *next;
	struct frefsym *prev;
} frefsym;

extern frefsym *frshead;
extern frefsym *frstail;

void init_lines();
line* mk_line(short, char *);
rsym* mk_rsym(line *, char *);
void free_lines(line *);
void free_rsyms(rsym *);
char* copy_str(const char*);
int lblookup(char *, short *);
int idlookup(char *s, short *);
void print_instr(line *);
void print_lines(line *);
void print_symbols(line *);
void eval_line(line *, char *);

arg* mk_arg(short);
void free_args(arg *);
void fill(short, unsigned char);
void print_args(int, line *);

void hexout(FILE *, int, int , int);

frefsym* mk_frefsym(char *, line *);
void free_frefsyms(frefsym *);
void print_frefsyms(frefsym *);
int frslookup(char *s, frefsym* *frs);

frefline* mk_frefline(line *);

#endif // LINES_FILE_H

