#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "parser.h"
#include "lines.h"
#include "minibas.h"

bool hexeor;
arg *first_arg;
arg *last_arg;
int nargs;
line *tail;
line *head;
frefsym *frshead;
frefsym *frstail;

void print_args(int asbytes, line *line)
{
    arg *pt;
    unsigned char byte;
    int i;

    pt = line->args;
    i = 0;

    if (pt == NULL) {
        fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
        return;
    }
    
    if (!asbytes) {
        fprintf(lst," %4.4X %4.4X", line->lc, uint16(pt->val));
        hexout(obj, ((pt->val) >> 8) & 0xFF, (line->lc) + i++, 0);
        hexout(obj, (pt->val) & 0xFF, (line->lc) + i++, 0);

        pt = pt->next;
        fprintf(lst,"\t%s", line->srcline);

	    while (pt) {
            fprintf(lst,"          %4.4X\n", uint16(pt->val));
            hexout(obj, ((pt->val) >> 8) & 0xFF, (line->lc) + i++, 0);
            hexout(obj, (pt->val) & 0xFF, (line->lc) + i++, 0);
            pt = pt->next;
        }
    } else {
        byte = pt->val;
        pt = pt->next;
        if (!pt) {
            fprintf(lst," %4.4X %2.2X", line->lc, uint8(byte));
            fprintf(lst,"\t%s", line->srcline);
            hexout(obj, byte & 0xFF, line->lc + i++, 0);
        } else {
            fprintf(lst," %4.4X %4.4X", line->lc, (byte << 8 | pt->val));
            fprintf(lst,"\t%s", line->srcline);
            hexout(obj, byte & 0xFF, line->lc + i++, 0);
            hexout(obj, (pt->val) & 0xFF, line->lc + i++, 0);
            pt = pt->next;
            if (pt) {
                byte = pt->val;
                pt = pt->next;
                if (!pt) {
                    fprintf(lst,"          %2.2X\n", byte);
                    hexout(obj, byte & 0xFF, line->lc + i++, 0);
                }
            }
	        while (pt) {
                fprintf(lst,"          %4.4X\n", (byte << 8 | pt->val));
                hexout(obj, byte & 0xFF, line->lc + i++, 0);
                hexout(obj, (pt->val) & 0xFF, line->lc + i++, 0);
                pt = pt->next;
                if (pt) {
                    byte = pt->val;
                    pt = pt->next;
                    if (!pt) {
                        fprintf(lst,"          %2.2X\n", uint8(byte));
                        hexout(obj, byte & 0xFF, line->lc + i++, 0);
                    }
                }
            }            
        }
    }
    hexeor = true;
}

void print_symbols(line *line)
{
    unsigned short val;
    rsym* rsptr;

	if (!line) {
        fprintf(lst,"\n");
        return;
    }

    if (line->ident) {
        val = line->idval;
        if ((int)strlen(line->ident) < 4)
            fprintf(lst,"%s\t\t%4.4X\n", line->ident, uint16(val));
        else
            fprintf(lst,"%s\t%4.4X\n", line->ident, uint16(val));
    } else if (line->label) {
        val = line->lbval;
        if ((int)strlen(line->label) < 4)
            fprintf(lst,"%s\t\t%4.4X\n", line->label, uint16(val));
        else
            fprintf(lst,"%s\t%4.4X\n", line->label, uint16(val));
    }

	print_symbols(line->next);
}

void print_instr(line *line)
{
    int op;
    int addr;
    short instr;
    unsigned char sinstr;

    if (line->idtype == UDEF)
        printf("%s:%d:%d:%s\n", filename, line->lineno, 0, "Símbolo no definido");

    switch (line->token) {
	    case T_COMM:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	    case T_EOL:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	    case T_LABEL:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	    case T_DOT:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	    case T_ALIGN:
            print_args(1, line);
            break;       
	    case T_ORG:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            if(hexeor) {
                hexout(obj, 0, 0, 2);
            }
            break;       
	    case T_EQU:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	    case T_SPACE:
            print_args(1, line);
            break;       
	    case T_BYTE:
            print_args(1, line);
            break;       
	    case T_WORD:
            print_args(0, line);
            break;       
	    case T_ASCIZ:
            print_args(0, line);
            break;       
	    case T_ASCII:
            print_args(0, line);
            break;       
	    case T_INSTR:
            op = (line->idval >> 8) & 0xFFFF;
            addr = (line->idval) & 0xFFFF;
            if ((op & 0xFF00) >= 0xC000) {            
                sinstr = op >> 8;
                if ((op & 0xF000) >= 0xD000) 
                    sinstr |= addr;
                fprintf(lst," %4.4X %2.2X\t%s", line->lc, (unsigned char)sinstr, line->srcline);
                hexout(obj, (unsigned char)sinstr, line->lc, 0);
            } else {
                instr = op & 0xFF00;
                int pag;
                pag = addr >> 8;
                unsigned char off;
                off = addr & 0xFF;
                if (pag == 1) {
                    instr |= 0x0400;
                }
                else if (pag == 2) {
                    instr |= 0x0800;
                }
                else if (pag >= 3) {
                    instr |= 0x0C00;
                }
                else {
                 }
                instr |= off;     
                fprintf(lst," %4.4X %4.4X\t%s", line->lc, (unsigned short)instr, line->srcline);
                hexout(obj, (((unsigned short)instr) >> 8) & 0xFF, line->lc, 0);
                hexout(obj, ((unsigned short)instr) & 0xFF, line->lc + 1, 0);
            }
            break;       
	    default:
            fprintf(lst," %4.4X\t%s", line->lc, line->srcline);
            break;       
	}
}

void print_lines(line *line)
{
	if (!line) {
        fprintf(lst,"\n");
        if (hexeor) {
            hexout(obj, 0, 0, 1);
        }
        return;
    }

    fprintf(lst,"%4d", line->lineno);
    print_instr(line);

	print_lines(line->next);
}

int lblookup(char *s, short * val)
{
    int ret;
    line *line;

    ret = -1;
    line = head;

    while (line) {
        if (line->label && (strcmp(line->label, s) == 0)) {
            *val = line->lbval;
            ret = 1;
            break;
        }
        line = line->next;
    }

    return ret;
}

int idlookup(char *s, short * val)
{
    int ret;
    line *line;

    ret = -1;
    line = head;

    while (line) {
        if (line->ident && (strcmp(line->ident, s) == 0)) {
            *val = line->idval;
            ret = 1;
            break;
        }
        line = line->next;
    }

    return ret;
}

void fill(short size, unsigned char val)
{
    first_arg = mk_arg(val);
    tail->args = first_arg;
    last_arg = first_arg;
    for (int i = 0; i < size-1; i++) {
        last_arg->next = mk_arg(val);
        last_arg = last_arg->next;
    }
}

void init_lines()
{
	tail = NULL;
	head = NULL;
   
}

line* mk_line(short lineno, char *srcline)
{
	line* i = malloc(sizeof(line));

    i->lineno = lineno;
	i->srcline = srcline;
    i->idtype = DEF;
    i->frefno = 0;
    i->reeval = false;   
	i->prev = tail;
	tail = i;
    
    if (head == NULL)
        head = i;
    else
        i->prev->next = i;

	return i;
}

void free_lines(line *line)
{
	if (!line) return;
	free_lines(line->prev);

	free(line->label);
	free(line->ident);    
	free(line->srcline);
	free_args(line->args);

	free(line);
}

arg* mk_arg(short val)
{
	arg* a = malloc(sizeof(arg));
	a->val  = val;
	a->next = NULL;
    nargs += 1;
	return a;
}

void free_args(arg *args)
{
	if (!args) return;
	free_args(args->next);
	free(args);
}

frefsym* mk_frefsym(char * sym, line * line)
{
	frefsym* f = malloc(sizeof(frefsym));
    frefline* frl;

    f->sym = sym;
    frl = mk_frefline(line);
    f->head = frl;
    f->tail = frl;
   
	f->prev = frstail;
	frstail = f;
    if (frshead == NULL)
        frshead = f;
    else
        f->prev->next = f;

	return f;
}

void free_frefsyms(frefsym *f)
{
	if (!f) return;
	free_frefsyms(f->prev);

	free(f);
}

void print_freflines(frefline *f)
{
	if (!f) {
        fprintf(lst,"\n");
        return;
    }

    fprintf(lst," %d", f->line->lineno);

	print_freflines(f->next);
}

void print_frefsyms(frefsym *f)
{
	if (!f) {
        fprintf(lst,"\n");
        return;
    }

    if ((int)strlen(f->sym) >= 7)
        fprintf(lst," %s\t", f->sym);
    else if ((int)strlen(f->sym) >= 3)
        fprintf(lst," %s\t\t", f->sym);
    else
        fprintf(lst," %s\t\t\t", f->sym);

    print_freflines(f->head);

	print_frefsyms(f->next);
}

int frslookup(char *s, frefsym* *frs)
{
    int ret;
    frefsym *f;

    ret = -1;
    f = frshead;
    
    while (f) {
        if (f->sym && (strcmp(f->sym, s) == 0)) {
            *frs = f;
            ret = 1;
            break;
        }
        f = f->next;
    }

    return ret;
}

frefline* mk_frefline(line * line)
{
	frefline* f = malloc(sizeof(frefline));

    f->line = line;

	f->next = NULL;

	return f;
}

